/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BKSGraph
implements Shape,
Cloneable {
    private static final boolean debug = false;
    private int IDZaehler = 1000;
    private int ID;
    public String Beschriftung;
    public Color Farbe;
    public BasicStroke LinienTyp;
    public GeneralPath Pfad = new GeneralPath();
    public Point2D.Double BeschriftungsPos;

    public GeneralPath getGeneralPath() {
        return this.Pfad;
    }

    public Color getColor() {
        return this.Farbe;
    }

    public String getBeschriftung() {
        return this.Beschriftung;
    }

    public Point2D.Double getBeschriftungsPos() {
        return this.BeschriftungsPos;
    }

    public BasicStroke getBasicStroke() {
        return this.LinienTyp;
    }

    public void setGeneralPath(GeneralPath generalPath) {
        this.Pfad = generalPath;
    }

    public void setPoint2D(Point2D[] point2DArray) {
        this.Pfad.reset();
        this.Pfad.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
        if (point2DArray.length > 1) {
            int n = 1;
            while (n < point2DArray.length) {
                this.Pfad.lineTo((float)point2DArray[n].getX(), (float)point2DArray[n].getY());
                ++n;
            }
        }
    }

    public void setColor(Color color) {
        this.Farbe = color;
    }

    public void setBeschriftung(String string) {
        this.Beschriftung = string;
    }

    public void setBeschriftungsPos(double d, double d2) {
        this.BeschriftungsPos = new Point2D.Double(d, d2);
    }

    public boolean setBeschriftungsPosAuto(Rectangle2D rectangle2D) {
        if (this.Pfad == null) {
            return false;
        }
        double[] dArray = new double[6];
        PathIterator pathIterator = this.Pfad.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            if (rectangle2D.contains(dArray[0], dArray[1])) {
                this.BeschriftungsPos = new Point2D.Double(dArray[0], dArray[1]);
                return true;
            }
            pathIterator.next();
        }
        return false;
    }

    public void setBasicStroke(BasicStroke basicStroke) {
        this.LinienTyp = basicStroke;
    }

    protected double AbstandZumGraph(Point2D.Double double_) {
        return this.AbstandZumGraph(double_, new double[4]);
    }

    public double[] AbstandZumGraphUndNahesterPunkt(Point2D.Double double_) {
        double[] dArray = new double[4];
        double d = this.AbstandZumGraph(double_, dArray);
        dArray = this.nahesterPunkt(dArray[0], dArray[1], dArray[2], dArray[3], double_.x, double_.y);
        double[] dArray2 = new double[]{d, dArray[0], dArray[1]};
        return dArray2;
    }

    protected double AbstandZumGraph(Point2D.Double double_, double[] dArray) {
        double[] dArray2 = new double[6];
        double d = Double.POSITIVE_INFINITY;
        Point2D.Double double_2 = null;
        PathIterator pathIterator = this.Pfad.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray2)) {
                case 0: {
                    double_2 = new Point2D.Double(dArray2[0], dArray2[1]);
                    if (!(double_.distance(double_2.x, double_2.y) < d)) break;
                    d = double_.distance(double_2.x, double_2.y);
                    dArray[0] = double_2.x;
                    dArray[1] = double_2.y;
                    break;
                }
                case 1: {
                    if (double_2 != null && Line2D.ptSegDist(double_2.x, double_2.y, dArray2[0], dArray2[1], double_.x, double_.y) < d) {
                        d = Line2D.ptSegDist(double_2.x, double_2.y, dArray2[0], dArray2[1], double_.x, double_.y);
                        dArray[0] = double_2.x;
                        dArray[1] = double_2.y;
                        dArray[2] = dArray2[0];
                        dArray[3] = dArray2[1];
                    }
                    double_2 = new Point2D.Double(dArray2[0], dArray2[1]);
                    break;
                }
                case 2: {
                    if (!new Rectangle2D.Double(dArray2[0], dArray2[1], dArray2[2], dArray2[3]).contains(double_.x, double_.y)) break;
                    dArray = dArray2;
                    return 0.0;
                }
                case 3: {
                    if (!new CubicCurve2D.Double(double_2.x, double_2.y, dArray2[0], dArray2[1], dArray2[2], dArray2[3], dArray2[4], dArray2[5]).contains(double_.x, double_.y)) break;
                    dArray = dArray2;
                    return 0.0;
                }
                case 4: {
                    break;
                }
                default: {
                    System.out.println("Gew\u00e4hltest Element " + pathIterator.currentSegment(dArray2) + " nicht \u00fcberpr\u00fcfbar");
                }
            }
            pathIterator.next();
        }
        return d;
    }

    protected double[] nahesterPunkt(double d, double d2, double d3, double d4, double d5, double d6) {
        if (Point2D.distance(d, d2, d5, d6) <= Point2D.distance(d3, d4, d5, d6)) {
            double[] dArray = new double[]{d, d2};
            return dArray;
        }
        double[] dArray = new double[]{d3, d4};
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object clone() {
        BKSGraph bKSGraph = null;
        try {
            bKSGraph = (BKSGraph)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Clonen nicht erfolgreich " + cloneNotSupportedException);
        }
        bKSGraph.Pfad = (GeneralPath)this.Pfad.clone();
        return bKSGraph;
    }

    public boolean contains(double d, double d2) {
        return this.Pfad.contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.Pfad.contains(d, d2, d3, d4);
    }

    public boolean contains(Point2D point2D) {
        return this.Pfad.contains(point2D);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.Pfad.contains(rectangle2D);
    }

    public Rectangle getBounds() {
        return this.Pfad.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.Pfad.getBounds2D();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.Pfad.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.Pfad.getPathIterator(affineTransform, d);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.Pfad.intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.Pfad.intersects(rectangle2D);
    }

    public BKSGraph(GeneralPath generalPath, String string, Color color, BasicStroke basicStroke) {
        this(string, color, basicStroke);
        this.Pfad = generalPath;
    }

    public BKSGraph(String string, Color color, BasicStroke basicStroke) {
        this.ID = this.IDZaehler++;
        this.Beschriftung = string;
        this.Farbe = color;
        this.LinienTyp = basicStroke;
    }

    public BKSGraph() {
        this("", Color.black, new BasicStroke());
    }

    public BKSGraph(GeneralPath generalPath) {
        this(generalPath, "", Color.black, new BasicStroke());
    }
}

