/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class KoordinatenSystem
extends JPanel {
    static final int KEIN_RASTER = 0;
    static final int KURZE_TEILSTRICHE = 1;
    static final int DRUCHGEZOGENES_RASTER = 2;
    public static final Point2D.Double Fluchtpunkt = new Point2D.Double(1000.0, 1000.0);
    static final boolean debug = false;
    private static int dbg_count = 0;
    public int x_Min;
    public int x_Max;
    public int y_Min;
    public int y_Max;
    private int BestStreckung = 30;
    protected AffineTransform skal = new AffineTransform();
    protected int RasterModus = 1;
    protected boolean ZeichneBeschriftung = false;
    protected boolean zeichnePerspektiv = false;
    protected String x_Achse;
    protected String y_Achse;
    protected String Ursprung;
    protected String EineEinheit;
    protected double Streckung = this.BestStreckung;
    protected double letzteH\u00f6he;
    protected double letzteBreite;
    protected Font Schrift;
    private double abstndZmKrz = 0.25;
    private int Rand = this.BestStreckung / 2;
    private int yPlatz = 0;
    private int xPlatz = 0;
    private Object AntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
    public boolean FormatGeaendert = true;

    public void setzeBeschriftung(String string, String string2, String string3, String string4) {
        this.ZeichneBeschriftung = true;
        this.x_Achse = string;
        this.y_Achse = string2;
        this.Ursprung = string3;
        this.EineEinheit = string4;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize(null);
        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        if (this.letzteH\u00f6he != (double)dimension.height | this.letzteBreite != (double)dimension.width | this.FormatGeaendert) {
            this.setFormat();
            this.FormatGeaendert = false;
            this.Streckung = d / this.getPreferredSize().getWidth() < d2 / this.getPreferredSize().getHeight() ? (d - (double)(2 * this.Rand) - (double)this.xPlatz) / (double)(this.x_Min + this.x_Max) : (d2 - (double)(2 * this.Rand) - (double)this.yPlatz) / (double)(this.y_Min + this.y_Max);
            this.skal.setToScale(this.Streckung, -1.0 * this.Streckung);
            this.skal.translate((double)(this.xPlatz + this.Rand) / this.Streckung + (double)this.x_Min, -1.0 * ((double)this.Rand / this.Streckung + (double)this.y_Max));
        }
        this.letzteH\u00f6he = dimension.height;
        this.letzteBreite = dimension.width;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-1 * this.x_Min, 0.0f);
        generalPath.lineTo(this.x_Max, 0.0f);
        generalPath.moveTo(0.0f, -1 * this.y_Min);
        generalPath.lineTo(0.0f, this.y_Max);
        generalPath.moveTo((float)((double)this.x_Max - 0.5), 0.5f);
        generalPath.lineTo(this.x_Max, 0.0f);
        generalPath.lineTo((float)((double)this.x_Max - 0.5), -0.5f);
        generalPath.moveTo(-0.5f, (float)((double)this.y_Max - 0.5));
        generalPath.lineTo(0.0f, this.y_Max);
        generalPath.lineTo(0.5f, (float)((double)this.y_Max - 0.5));
        BasicStroke basicStroke = new BasicStroke(1.5f, 1, 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.skal.createTransformedShape(this.ifPerspektiv(generalPath)));
        this.RasterZeichnen(graphics2D, this.skal);
        if (this.ZeichneBeschriftung) {
            this.ZeichneBeschriftungX(graphics2D);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getPreferredSize().width / 10, this.getPreferredSize().height / 10);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.BestStreckung * (this.x_Min + this.x_Max) + 2 * this.Rand + this.xPlatz, this.BestStreckung * (this.y_Min + this.y_Max) + 2 * this.Rand + this.yPlatz);
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void RasterZeichnen(Graphics2D graphics2D, AffineTransform affineTransform) {
        switch (this.RasterModus) {
            case 0: {
                break;
            }
            case 1: {
                GeneralPath generalPath = new GeneralPath();
                int n = -1 * this.x_Min;
                while (n <= this.x_Max) {
                    generalPath.moveTo(n, -0.25f);
                    generalPath.lineTo(n, 0.25f);
                    ++n;
                }
                n = -1 * this.y_Min;
                while (n <= this.y_Max) {
                    generalPath.moveTo(-0.25f, n);
                    generalPath.lineTo(0.25f, n);
                    ++n;
                }
                BasicStroke basicStroke = new BasicStroke(0.5f, 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(this.skal.createTransformedShape(this.ifPerspektiv(generalPath)));
                break;
            }
            case 2: {
                GeneralPath generalPath = new GeneralPath();
                int n = -1 * this.x_Min;
                while (n <= this.x_Max) {
                    generalPath.moveTo(n, -this.y_Min);
                    generalPath.lineTo(n, this.y_Max);
                    ++n;
                }
                n = -1 * this.y_Min;
                while (n <= this.y_Max) {
                    generalPath.moveTo(-this.x_Min, n);
                    generalPath.lineTo(this.x_Max, n);
                    ++n;
                }
                BasicStroke basicStroke = new BasicStroke(0.5f, 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(this.skal.createTransformedShape(this.ifPerspektiv(generalPath)));
                break;
            }
            default: {
                System.out.println("RasterModus des Koordinatensystems nicht richtig gesetzt!");
            }
        }
    }

    protected double PD(double d) {
        return this.Streckung / 2.0 + d * this.Streckung;
    }

    private void ZeichneBeschriftungWA(Graphics2D graphics2D, AffineTransform affineTransform) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        TextLayout textLayout = new TextLayout(this.x_Achse, font, fontRenderContext);
        double d = textLayout.getBounds().getHeight() + 4.0;
        textLayout.draw(graphics2D, (float)(this.PD(this.x_Min + this.x_Max) - textLayout.getBounds().getWidth()), (float)(this.PD(this.y_Max) + d + this.Streckung / 2.0));
        textLayout = new TextLayout(this.y_Achse, font, fontRenderContext);
        textLayout.draw(graphics2D, (float)(this.PD(this.x_Min) - textLayout.getBounds().getWidth() - this.Streckung / 2.0), (float)(this.PD(0.0) + textLayout.getBounds().getHeight()));
        textLayout = new TextLayout(this.Ursprung, font, fontRenderContext);
        textLayout.draw(graphics2D, (float)(this.PD(this.x_Min) - textLayout.getBounds().getWidth() - this.Streckung / 2.0), (float)(this.PD(this.y_Max) + d + this.Streckung / 2.0));
        textLayout = new TextLayout(this.EineEinheit, font, fontRenderContext);
        textLayout.draw(graphics2D, (float)(this.PD(this.x_Min + 1) - textLayout.getBounds().getWidth() / 2.0), (float)(this.PD(this.y_Max) + d + this.Streckung / 2.0));
    }

    protected void ZeichneText(Graphics2D graphics2D, Font font, String string, Point2D.Double double_) {
        double_ = this.ifPerspektiv(double_);
        this.skal.transform(double_, double_);
        graphics2D.setFont(font);
        graphics2D.drawString(string, (float)double_.x, (float)double_.y);
    }

    protected void ZeichneText(Graphics2D graphics2D, String string, Point2D.Double double_) {
        this.ZeichneText(graphics2D, this.Schrift, string, double_);
    }

    private void ZeichneBeschriftungX(Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.Schrift;
        TextLayout textLayout = new TextLayout(this.x_Achse, font, fontRenderContext);
        double d = textLayout.getBounds().getHeight() / this.Streckung + 0.5;
        double d2 = textLayout.getBounds().getWidth() / this.Streckung;
        this.ZeichneText(graphics2D, font, this.x_Achse, new Point2D.Double((double)this.x_Max - d2, 0.0 - d));
        textLayout = new TextLayout(this.y_Achse, font, fontRenderContext);
        d = textLayout.getBounds().getHeight() / this.Streckung;
        d2 = textLayout.getBounds().getWidth() / this.Streckung + 0.5;
        this.ZeichneText(graphics2D, font, this.y_Achse, new Point2D.Double(0.0 - d2, (double)this.y_Max - d));
        textLayout = new TextLayout(this.Ursprung, font, fontRenderContext);
        d = textLayout.getBounds().getHeight() / 2.0 / this.Streckung + this.abstndZmKrz;
        d2 = textLayout.getBounds().getWidth() / this.Streckung + this.abstndZmKrz;
        this.ZeichneText(graphics2D, font, this.Ursprung, new Point2D.Double(0.0 - d2, 0.0 - d));
        textLayout = new TextLayout(this.EineEinheit, font, fontRenderContext);
        d = textLayout.getBounds().getHeight() / this.Streckung + this.abstndZmKrz;
        d2 = textLayout.getBounds().getWidth() / 2.0 / this.Streckung;
        this.ZeichneText(graphics2D, font, this.EineEinheit, new Point2D.Double(1.0 - d2, 0.0 - d));
        textLayout = new TextLayout(this.EineEinheit, font, fontRenderContext);
        d = textLayout.getBounds().getHeight() / 2.0 / this.Streckung;
        d2 = textLayout.getBounds().getWidth() / this.Streckung + this.abstndZmKrz;
        this.ZeichneText(graphics2D, font, this.EineEinheit, new Point2D.Double(0.0 - d2, 1.0 - d));
    }

    public void aendereFormat(int n, int n2, int n3, int n4, boolean bl) {
        this.x_Min = n;
        this.x_Max = n2;
        this.y_Min = n3;
        this.y_Max = n4;
        this.zeichnePerspektiv = bl;
        if (bl) {
            this.y_Max += this.y_Min + this.y_Max;
        }
        this.FormatGeaendert = true;
        if ((Graphics2D)this.getGraphics() != null) {
            this.repaint();
        }
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    protected void setFormat() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setFont(this.Schrift);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.Ursprung, this.Schrift, fontRenderContext);
        double d = textLayout.getBounds().getHeight();
        double d2 = textLayout.getBounds().getWidth();
        this.yPlatz = this.y_Min < 1 ? (int)(d + this.Streckung * this.abstndZmKrz) : 0;
        this.xPlatz = this.x_Min < 1 ? (int)(d2 + this.Streckung * this.abstndZmKrz) : 0;
        this.FormatGeaendert = false;
        this.repaint();
    }

    protected GeneralPath transPerspektiv(Shape shape) {
        double[] dArray = new double[6];
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        if (shape instanceof BKSMarke) {
            double[] dArray2 = new double[]{((BKSMarke)shape).getPosition().x, ((BKSMarke)shape).getPosition().y};
            if ((dArray2[0] < (double)(-this.x_Min) || dArray2[0] > (double)this.x_Max || dArray2[1] < (double)(-this.y_Min) || dArray2[1] > (double)this.y_Max) && (dArray2[0] != KoordinatenSystem.Fluchtpunkt.x || dArray2[0] != KoordinatenSystem.Fluchtpunkt.y)) {
                return generalPath;
            }
            dArray2 = this.tPHilf(dArray2[0], dArray2[1]);
            shape = (Shape)((BKSMarke)shape).clone();
            ((BKSMarke)shape).setMarke(new Point2D.Double(dArray2[0], dArray2[1]));
            return ((BKSMarke)shape).getMarke();
        }
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if ((dArray[0] < (double)(-this.x_Min) || dArray[0] > (double)this.x_Max || dArray[1] < (double)(-this.y_Min) || dArray[1] > (double)this.y_Max) && (dArray[0] != KoordinatenSystem.Fluchtpunkt.x || dArray[0] != KoordinatenSystem.Fluchtpunkt.y)) {
                bl = true;
            } else {
                if (bl) {
                    n = 0;
                    bl = false;
                }
                switch (n) {
                    case 0: {
                        double[] dArray3 = this.tPHilf(dArray[0], dArray[1]);
                        generalPath.moveTo((float)dArray3[0], (float)dArray3[1]);
                        break;
                    }
                    case 1: {
                        double[] dArray3 = this.tPHilf(dArray[0], dArray[1]);
                        generalPath.lineTo((float)dArray3[0], (float)dArray3[1]);
                        break;
                    }
                    case 2: {
                        double[] dArray3 = this.tPHilf(dArray[0], dArray[1]);
                        double[] dArray4 = this.tPHilf(dArray[2], dArray[3]);
                        generalPath.quadTo((float)dArray3[0], (float)dArray3[1], (float)dArray4[0], (float)dArray4[1]);
                        break;
                    }
                    case 3: {
                        double[] dArray3 = this.tPHilf(dArray[0], dArray[1]);
                        double[] dArray4 = this.tPHilf(dArray[2], dArray[3]);
                        double[] dArray5 = this.tPHilf(dArray[4], dArray[5]);
                        generalPath.curveTo((float)dArray3[0], (float)dArray3[1], (float)dArray4[0], (float)dArray4[1], (float)dArray5[0], (float)dArray5[1]);
                        break;
                    }
                    case 4: {
                        generalPath.closePath();
                        break;
                    }
                    default: {
                        System.out.println("Gew\u00e4hltest Element " + pathIterator.currentSegment(dArray) + " nicht \u00fcberpr\u00fcfbar");
                    }
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    protected double[] tPHilf(double d, double d2) {
        if (new Point2D.Double(d, d2).equals(Fluchtpunkt)) {
            d = this.getRealPunktFuerFluchtPunkt().x;
            d2 = this.getRealPunktFuerFluchtPunkt().y;
        }
        double d3 = (double)this.y_Max - ((double)this.y_Max - d2) * ((double)this.y_Max - d2) / (double)(this.y_Min + this.y_Max);
        double[] dArray = new double[]{-(d * (d3 - (double)this.y_Max) / (double)this.y_Max), d3};
        return dArray;
    }

    protected double[] Debug_tPHilf(double d, double d2) {
        double[] dArray = this.tPHilf(d, d2);
        System.out.println("Ursprungs Wert:    " + d + " / " + d2 + " ->" + dArray[0] + " / " + dArray[1]);
        System.out.println("Und wieder zur\u00fcck: " + this.transInversPerspektiv(new Point2D.Double(dArray[0], dArray[1])).toString());
        return dArray;
    }

    protected Shape ifPerspektiv(Shape shape) {
        if (this.zeichnePerspektiv) {
            return this.transPerspektiv(shape);
        }
        return shape;
    }

    protected Point2D.Double ifInversPerspektiv(Point2D.Double double_) {
        if (this.zeichnePerspektiv) {
            return this.transInversPerspektiv(double_);
        }
        return double_;
    }

    protected Point2D.Double ifPerspektiv(Point2D.Double double_) {
        if (this.zeichnePerspektiv) {
            return this.transPerspektiv(double_);
        }
        return double_;
    }

    protected Point2D.Double transInversPerspektiv(Point2D.Double double_) {
        if (double_.equals(this.getRealPunktFuerFluchtPunkt())) {
            return Fluchtpunkt;
        }
        double d = -(double_.x * (double)this.y_Max) / (double_.y - (double)this.y_Max);
        double d2 = (double)this.y_Max - Math.sqrt(((double)this.y_Max - double_.y) * (double)(this.y_Min + this.y_Max));
        return new Point2D.Double(d, d2);
    }

    protected Point2D.Double transPerspektiv(Point2D.Double double_) {
        double[] dArray = this.tPHilf(double_.x, double_.y);
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    public int getRasterModus() {
        return this.RasterModus;
    }

    public void setRasterModus(int n) {
        this.RasterModus = n;
    }

    public String getEineEinheit() {
        return this.EineEinheit;
    }

    public void setEineEinheit(String string) {
        this.EineEinheit = string;
    }

    public double getStreckung() {
        return this.Streckung;
    }

    public void setStreckung(double d) {
        this.Streckung = d;
    }

    public String getX_Achse() {
        return this.x_Achse;
    }

    public void setX_Achse(String string) {
        this.x_Achse = string;
    }

    public String getUrsprung() {
        return this.Ursprung;
    }

    public void setUrsprung(String string) {
        this.Ursprung = string;
    }

    public String getY_Achse() {
        return this.y_Achse;
    }

    public void setY_Achse(String string) {
        this.y_Achse = string;
    }

    public boolean getZeichneBeschriftung() {
        return this.ZeichneBeschriftung;
    }

    public void setZeichneBeschriftung(boolean bl) {
        this.ZeichneBeschriftung = bl;
    }

    public Point2D.Double getRealPunktFuerFluchtPunkt() {
        return new Point2D.Double(0.0, this.y_Max);
    }

    KoordinatenSystem(int n, int n2, int n3, int n4) {
        this.aendereFormat(n, n2, n3, n4, this.zeichnePerspektiv);
        this.Schrift = this.getFont();
        if (n3 < 1) {
            this.yPlatz += this.BestStreckung;
        }
        if (n < 1) {
            this.xPlatz += this.BestStreckung;
        }
    }

    KoordinatenSystem(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4);
        this.RasterModus = n5;
        this.BestStreckung = n6;
        this.Streckung = this.BestStreckung;
        this.Rand = this.BestStreckung / 2;
    }
}

